/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWSimpleInstruction;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWDBExecuteParametersTableModel;
import filenet.vw.toolkit.design.property.tables.VWDataFieldNameCellEditor;
import filenet.vw.toolkit.utils.VWInstruction;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class VWDBExecuteParamPanel
extends JPanel
implements IVWToolbarBorderActionListener,
TableModelListener,
ListSelectionListener,
DocumentListener {
    private VWAuthPropertyData m_authPropertyData = null;
    private VWSimpleInstruction m_instructionDef = null;
    private int m_nOrientation = 0;
    private JTextField m_databaseTextField = null;
    private JTextField m_storedProcedureNameTextField = null;
    private VWToolbarBorder m_parametersBorder = null;
    private VWDBExecuteParametersTableModel m_dbExecuteParamTableModel = null;
    private VWTable m_parametersTable = null;

    public VWDBExecuteParamPanel(int nOrientation) {
        switch (nOrientation) {
            case 0: 
            case 1: {
                this.m_nOrientation = nOrientation;
            }
        }
    }

    public void init(VWAuthPropertyData authPropertyData) {
        this.m_authPropertyData = authPropertyData;
        this.initControls();
        if (this.m_parametersTable != null) {
            this.m_parametersTable.clearSelection();
        }
    }

    public void setInstructionDefinition(VWInstructionDefinition instructionDef) {
        if (this.m_parametersTable != null) {
            this.m_parametersTable.stopEditing();
        }
        if (instructionDef != null && instructionDef instanceof VWSimpleInstruction) {
            this.m_instructionDef = (VWSimpleInstruction)instructionDef;
            String dbName = VWInstruction.DatabaseExecuteInstructionGetDatabaseName(this.m_instructionDef);
            if (dbName != null && dbName.length() > 0) {
                dbName = dbName.substring(1, dbName.length() - 1);
            }
            this.m_databaseTextField.getDocument().removeDocumentListener(this);
            this.m_databaseTextField.setText(dbName);
            this.m_databaseTextField.getDocument().addDocumentListener(this);
            this.m_databaseTextField.setEnabled(true);
            String storedProcName = VWInstruction.DatabaseExecuteInstructionGetStoredProcName(this.m_instructionDef);
            if (storedProcName != null && storedProcName.length() > 0) {
                storedProcName = storedProcName.substring(1, storedProcName.length() - 1);
            }
            this.m_storedProcedureNameTextField.getDocument().removeDocumentListener(this);
            this.m_storedProcedureNameTextField.setText(storedProcName);
            this.m_storedProcedureNameTextField.getDocument().addDocumentListener(this);
            this.m_storedProcedureNameTextField.setEnabled(true);
        } else {
            this.m_instructionDef = null;
            this.m_databaseTextField.getDocument().removeDocumentListener(this);
            this.m_databaseTextField.setText("");
            this.m_databaseTextField.getDocument().addDocumentListener(this);
            this.m_databaseTextField.setEnabled(false);
            this.m_storedProcedureNameTextField.getDocument().removeDocumentListener(this);
            this.m_storedProcedureNameTextField.setText("");
            this.m_storedProcedureNameTextField.getDocument().addDocumentListener(this);
            this.m_storedProcedureNameTextField.setEnabled(false);
        }
        this.m_parametersTable.setEnabled(instructionDef != null);
        this.m_dbExecuteParamTableModel.setInstructionDefinition(instructionDef);
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            if (event.getSource().equals(this.m_parametersBorder)) {
                this.m_parametersTable.stopEditing();
                switch (event.getID()) {
                    case 0x10000000: {
                        this.m_dbExecuteParamTableModel.deleteItem(this.m_parametersTable.getSelectedRow());
                        break;
                    }
                    case 1: {
                        this.onUp();
                        break;
                    }
                    case 2: {
                        this.onDown();
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow() - 1;
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow == this.m_parametersTable.getSelectedRow()) {
                    this.m_parametersTable.clearSelection();
                }
                this.m_parametersTable.setRowSelectionInterval(nRow, nRow);
                break;
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            int nRowCount;
            this.m_parametersBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_parametersBorder.getClientPanel(), 2, Integer.MAX_VALUE));
            int nRowIndex = this.m_parametersTable.getSelectedRow();
            if (this.m_dbExecuteParamTableModel != null && nRowIndex != -1 && nRowIndex != (nRowCount = this.m_dbExecuteParamTableModel.getRowCount()) - 1) {
                this.m_parametersBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_parametersBorder.getClientPanel(), 1, Integer.MAX_VALUE));
                if (nRowIndex == 0) {
                    this.m_parametersBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_parametersBorder.getClientPanel(), 2, 1));
                }
                if (nRowIndex == nRowCount - 2) {
                    this.m_parametersBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_parametersBorder.getClientPanel(), 2, 2));
                }
                if (nRowCount == 1) {
                    this.m_parametersBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_parametersBorder.getClientPanel(), 2, 0x10000000));
                }
            }
        }
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void insertUpdate(DocumentEvent event) {
        try {
            if (event.getDocument().equals(this.m_databaseTextField.getDocument()) && this.m_instructionDef != null) {
                VWInstruction.DatabaseExecuteInstructionSetDatabaseName(this.m_instructionDef, "\"" + this.m_databaseTextField.getText() + "\"");
            } else if (event.getDocument().equals(this.m_storedProcedureNameTextField.getDocument()) && this.m_instructionDef != null) {
                VWInstruction.DatabaseExecuteInstructionSetStoredProcName(this.m_instructionDef, "\"" + this.m_storedProcedureNameTextField.getText() + "\"");
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void removeUpdate(DocumentEvent event) {
        try {
            if (event.getDocument().equals(this.m_databaseTextField.getDocument()) && this.m_instructionDef != null) {
                VWInstruction.DatabaseExecuteInstructionSetDatabaseName(this.m_instructionDef, "\"" + this.m_databaseTextField.getText() + "\"");
            } else if (event.getDocument().equals(this.m_storedProcedureNameTextField.getDocument()) && this.m_instructionDef != null) {
                VWInstruction.DatabaseExecuteInstructionSetStoredProcName(this.m_instructionDef, "\"" + this.m_storedProcedureNameTextField.getText() + "\"");
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void initControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.anchor = 23;
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 2;
        gbCons.weightx = 1.0;
        gbCons.weighty = 0.0;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(6, 6, 6, 6);
        switch (this.m_nOrientation) {
            case 1: {
                this.add((Component)this.createNamePanel(), gbCons);
                gbCons.gridx = 0;
                ++gbCons.gridy;
                gbCons.fill = 1;
                gbCons.weighty = 1.0;
                gbCons.gridwidth = 0;
                this.add((Component)this.createParametersPanel(), gbCons);
                break;
            }
            default: {
                gbCons.weightx = 0.5;
                this.add((Component)this.createNamePanel(), gbCons);
                ++gbCons.gridx;
                gbCons.fill = 1;
                gbCons.weighty = 1.0;
                gbCons.gridwidth = 0;
                this.add((Component)this.createParametersPanel(), gbCons);
            }
        }
    }

    private JPanel createNamePanel() {
        JPanel namePanel = new JPanel(new GridBagLayout());
        try {
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(6, 6, 6, 6);
            JLabel label = new JLabel(VWResource.s_colon.toString(VWResource.s_databaseConnectionAlias));
            namePanel.add((Component)label, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_databaseTextField = new JTextField();
            this.m_databaseTextField.getDocument().addDocumentListener(this);
            namePanel.add((Component)this.m_databaseTextField, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            label = new JLabel(VWResource.s_colon.toString(VWResource.s_procedureName));
            namePanel.add((Component)label, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_storedProcedureNameTextField = new JTextField();
            this.m_storedProcedureNameTextField.getDocument().addDocumentListener(this);
            namePanel.add((Component)this.m_storedProcedureNameTextField, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return namePanel;
    }

    private JPanel createParametersPanel() {
        try {
            this.m_parametersBorder = new VWToolbarBorder(VWResource.s_parameters, 0x10000003);
            this.m_parametersBorder.addToolbarBorderActionNotifier(this);
            this.m_parametersBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_parametersBorder.getClientPanel(), 2, Integer.MAX_VALUE));
            JPanel clientPanel = this.m_parametersBorder.getClientPanel();
            clientPanel.setLayout(new BorderLayout());
            this.m_dbExecuteParamTableModel = new VWDBExecuteParametersTableModel(this.m_authPropertyData, this.m_instructionDef);
            this.m_dbExecuteParamTableModel.addTableModelListener(this);
            this.m_parametersTable = new VWTable(this.m_dbExecuteParamTableModel);
            this.m_parametersTable.setRowSelectionAllowed(true);
            this.m_parametersTable.getSelectionModel().addListSelectionListener(this);
            this.m_parametersTable.getSelectionModel().setSelectionMode(0);
            TableColumn tcElement = this.m_parametersTable.getColumn(this.m_parametersTable.getColumnName(0));
            if (tcElement != null) {
                tcElement.setMinWidth(30);
                tcElement.setMaxWidth(30);
            }
            if ((tcElement = this.m_parametersTable.getColumnModel().getColumn(1)) != null) {
                tcElement.setCellEditor(new VWDataFieldNameCellEditor(this.m_authPropertyData));
            }
            clientPanel.add((Component)new JScrollPane(this.m_parametersTable), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_parametersBorder;
    }

    private void onUp() {
        try {
            int nRowIndex = this.m_parametersTable.getSelectedRow();
            if (nRowIndex > 0) {
                this.m_dbExecuteParamTableModel.up(nRowIndex);
                this.m_parametersTable.setRowSelectionInterval(nRowIndex - 1, nRowIndex - 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onDown() {
        try {
            int nRowIndex = this.m_parametersTable.getSelectedRow();
            if (nRowIndex < this.m_dbExecuteParamTableModel.getRowCount() - 2) {
                this.m_dbExecuteParamTableModel.down(nRowIndex);
                this.m_parametersTable.setRowSelectionInterval(nRowIndex + 1, nRowIndex + 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

